/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;

public class StepFunction
implements Float2FloatFunction {
    protected final float min;
    protected final int steps;
    protected final float step;

    public StepFunction(float min, int steps, float step) {
        this.min = min;
        this.steps = steps;
        this.step = step;
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
    }

    public float get(float level) {
        return this.min + (float)((int)((float)this.steps * (level + 0.5f / (float)this.steps))) * this.step;
    }

    public int getInt(float level) {
        return (int)this.get(level);
    }

    public float min() {
        return this.min;
    }

    public float max() {
        return this.min + (float)this.steps * this.step;
    }
}

